;--------------------------------------------------------
; File Created by ChiponCC : ChipON  inc.
;--------------------------------------------------------
; chipon port for the 16-bit core
;--------------------------------------------------------
	.file	"../lcd1602.c"
	.radix dec
	.include "KF8TS2716.inc"
;--------------------------------------------------------
; external declarations
;--------------------------------------------------------
	.extern	_init_mcu
	.extern	__R2PCL
	.extern	_TOUCH_DEBUG_TRS_DEAL
	.extern	_TOUCH_DEBUG_SEND_OUT
	.extern	__KF8TS27_Get_Ver_Slide_W_
	.extern	__KF8TS27_Init_Touch_Slide_W_
	.extern	__KF8TS27_Touch_Process_Slide_W_
	.extern	__KF8TS27_Touch_TEST_Slide_W_
	.extern	__KF8TS27_Lib_Set_Slide_W_Parameter
	.extern	_Write_cd4094
	.extern	_delay_ms
	.extern	_delay_us
	.extern	__modslong
	.extern	__divslong
	.extern	_STKR0
	.extern	_STK00
	.extern	_STK01
	.extern	_STK02
	.extern	_STK03
	.extern	_STK04
	.extern	_STK05
	.extern	_STK06
	.extern	_STK07
	.extern	_STK08
	.extern	_STK09
	.extern	_STK10
	.extern	_STK11
	.extern	_PSW_bits
	.extern	_P0_bits
	.extern	_P2_bits
	.extern	_P1_bits
	.extern	_P3_bits
	.extern	_INTCTL_bits
	.extern	_EIF1_bits
	.extern	_EIF2_bits
	.extern	_T1CTL_bits
	.extern	_PWMCTL_bits
	.extern	_BANK_bits
	.extern	_ADSCANCTL_bits
	.extern	_VDACS_bits
	.extern	_ANSEH_bits
	.extern	_ADCCTL0_bits
	.extern	_OPTR_bits
	.extern	_IP0_bits
	.extern	_IP1_bits
	.extern	_IP2_bits
	.extern	_TR0_bits
	.extern	_TR2_bits
	.extern	_TR1_bits
	.extern	_OSCSTA_bits
	.extern	_IP3_bits
	.extern	_VRECTL_bits
	.extern	_EIE1_bits
	.extern	_EIE2_bits
	.extern	_PCTL_bits
	.extern	_OSCCTL_bits
	.extern	_ANSEL_bits
	.extern	_PUR0_bits
	.extern	_IOCL_bits
	.extern	_ADCCTL1_bits
	.extern	_P0LR_bits
	.extern	_P2LR_bits
	.extern	_P1LR_bits
	.extern	_P3LR_bits
	.extern	_TR3_bits
	.extern	_EIE3_bits
	.extern	_EIF3_bits
	.extern	_T3CTL_bits
	.extern	_CTCTL0_bits
	.extern	_PUR1_bits
	.extern	_PUR2_bits
	.extern	_CTCTL1_bits
	.extern	_INTEDGCTL_bits
	.extern	_VBIASCTL_bits
	.extern	_VBIAS1EN_bits
	.extern	_VBIAS2EN_bits
	.extern	_VDAC_bits
	.extern	_RSCTL_bits
	.extern	_BRCTL_bits
	.extern	_TSCTL_bits
	.extern	_SSCICTL0_bits
	.extern	_SSCICTL1_bits
	.extern	_SSCISTA_bits
	.extern	_SSCIMSK_bits
	.extern	_WDTPS_bits
	.extern	_LEDCTL_bits
	.extern	_LEDPRE_bits
	.extern	_LEDDATA0_bits
	.extern	_LEDDATA1_bits
	.extern	_LEDDATA2_bits
	.extern	_LEDDATA3_bits
	.extern	_LEDDATA4_bits
	.extern	_LEDDATA5_bits
	.extern	_LEDDATA6_bits
	.extern	_LEDDATA7_bits
	.extern	_LEDOMS1_bits
	.extern	_LEDODS0_bits
	.extern	_LEDOMS0_bits
	.extern	_LEDODS1_bits
	.extern	_LEDLUM_bits
	.extern	_T4CTL_bits
	.extern	_sentbuf1
	.extern	_sentbuf2
	.extern	_sentbuf3
	.extern	_sentbuf4
	.extern	__KF8_LIBi_channel_flag_
	.extern	__KF8_LIBi_Slide_Press_Flag
	.extern	__KF8_LIBi_Slide_channel_out_
	.extern	__KF8_LIBi_Slide_distance_out_
	.extern	__KF8_LIBc_channel_
	.extern	__KF8_LIBi_Date_Change_
	.extern	__KF8_LIBc_baseline_count_
	.extern	__KF8_LIBi_buff_hit_
	.extern	__KF8_LIBi_buff_baseline_
	.extern	__KF8_LIBc_touch_count_
	.extern	__KF8_lib_Slide_Finded_MAX_I_T27_SW_
	.extern	__KF8_lib_Slide_Finded_MAX_I_Buf_T27_SW_
	.extern	__KF8_LIBi_Slide_round_count_
	.extern	__KF8_LIBi_Slide_channel_back_
	.extern	_CHS_AMOUNT
	.extern	_SLIDE_AMOUNT
	.extern	_TCS_AMOUNT
	.extern	_TCS_Slide_AMOUNT
	.extern	__KF8_Disturb_Protect_Circle_
	.extern	__KF8_DoubleKey_Compages_Limitable_Circle_
	.extern	__KF8_Key_Max_Pressed_Limitable_Circle_
	.extern	__KF8_BaseLine_Update_Circle_Count_For_UP_
	.extern	__KF8_BaseLine_Update_Circle_Count_For_Down_
	.extern	__KF8_Define_Disturb_Channels_Amount_
	.extern	__KF8_BasicLine_UP_Noise_Threshold_
	.extern	__KF8_BasicLine_Down_Noise_Threshold_
	.extern	__KF8_Data_Steady_Threshold_Set_
	.extern	__KF8_Inside_Reference_Channel_Disturb_Threshold_Set_
	.extern	__KF8_Inside_Reference_Channel_Declare_
	.extern	__KF8_TOUCH_CH_EN
	.extern	__SLIDE_DISTRIBUTION
	.extern	__SLIDE_RESOLUTION
	.extern	__SLIDE_SINGLE_RESOLUTION
	.extern	__SLIDE_OFFSET
	.extern	__KF8_Config_Finger_Threshold
	.extern	__KF8_Config_Finger_Threshold_In_Disturb_
	.extern	_T0
	.extern	_PCL
	.extern	_PSW
	.extern	_P0
	.extern	_P2
	.extern	_P1
	.extern	_P3
	.extern	_PCH
	.extern	_INTCTL
	.extern	_EIF1
	.extern	_EIF2
	.extern	_T1L
	.extern	_T1H
	.extern	_T1CTL
	.extern	_PWM1L
	.extern	_PWM1H
	.extern	_PWMCTL
	.extern	_PP1
	.extern	_BANK
	.extern	_ADSCANCTL
	.extern	_VDACS
	.extern	_ANSEH
	.extern	_ADCDATA0H
	.extern	_ADCCTL0
	.extern	_OPTR
	.extern	_IP0
	.extern	_IP1
	.extern	_IP2
	.extern	_TR0
	.extern	_TR2
	.extern	_TR1
	.extern	_OSCSTA
	.extern	_IP3
	.extern	_VRECAL1
	.extern	_VRECTL
	.extern	_EIE1
	.extern	_EIE2
	.extern	_PCTL
	.extern	_OSCCTL
	.extern	_OSCCAL0
	.extern	_ANSEL
	.extern	_PP2
	.extern	_PWM2L
	.extern	_PWM2H
	.extern	_PUR0
	.extern	_IOCL
	.extern	_OSCCAL1
	.extern	_NVMDATAH
	.extern	_NVMDATAL
	.extern	_NVMADDRH
	.extern	_NVMADDRL
	.extern	_NVMCTL0
	.extern	_NVMCTL1
	.extern	_ADCDATA0L
	.extern	_ADCCTL1
	.extern	_P0LR
	.extern	_P2LR
	.extern	_P1LR
	.extern	_P3LR
	.extern	_TR3
	.extern	_EIE3
	.extern	_EIF3
	.extern	_OSCCAL2
	.extern	_OSCCAL3
	.extern	_T3CTL
	.extern	_T3L
	.extern	_CTCTL0
	.extern	_T3H
	.extern	_PUR1
	.extern	_PUR2
	.extern	_CTCTL1
	.extern	_INTEDGCTL
	.extern	_VBIASCTL
	.extern	_VBIAS1EN
	.extern	_VBIAS2EN
	.extern	_VDAC
	.extern	_RSCTL
	.extern	_TXSDR
	.extern	_RXSDR
	.extern	_BRCTL
	.extern	_TSCTL
	.extern	_EUBRGL
	.extern	_EUBRGH
	.extern	_SSCICTL0
	.extern	_SSCICTL1
	.extern	_SSCISTA
	.extern	_SSCIBUFR
	.extern	_SSCIMSK
	.extern	_WDTPS
	.extern	_LEDCTL
	.extern	_LEDPRE
	.extern	_LEDDATA0
	.extern	_LEDDATA1
	.extern	_LEDDATA2
	.extern	_LEDDATA3
	.extern	_LEDDATA4
	.extern	_LEDDATA5
	.extern	_LEDDATA6
	.extern	_LEDDATA7
	.extern	_LEDOMS1
	.extern	_LEDODS0
	.extern	_LEDOMS0
	.extern	_LEDODS1
	.extern	_VRECAL2
	.extern	_VRECAL3
	.extern	_LEDLUM
	.extern	_T4L
	.extern	_T4H
	.extern	_T4REL
	.extern	_T4REH
	.extern	_T4CTL
	.extern	_RC32KCAL
	.extern	__gptrget1

	.extern I0R1
	.extern I0R7
	.extern I0PSW
	.extern I0PCH
	.extern I1R1
	.extern I1R7
	.extern I1PSW
	.extern I1PCH
	.extern STK11
	.extern STK10
	.extern STK09
	.extern STK08
	.extern STK07
	.extern STK06
	.extern STK05
	.extern STK04
	.extern STK03
	.extern STK02
	.extern STK01
	.extern STK00
;--------------------------------------------------------
; global declarations
;--------------------------------------------------------
	.global	_LCD1602_PrintHEX
	.global	_LCD1602_PrintHEX_TWO
	.global	_LCD1602_PrintInteger
	.global	_LCD1602_PrintString
	.global	_LCD1602_Clear
	.global	_LCD1602_setxy
	.global	_LCD1602_Init
	.global	_LCD1602WriteCmd
	.global	_LCD1602Write
	.define _STK11	STK11
	.define _STK10	STK10
	.define _STK09	STK09
	.define _STK08	STK08
	.define _STK07	STK07
	.define _STK06	STK06
	.define _STK05	STK05
	.define _STK04	STK04
	.define _STK03	STK03
	.define _STK02	STK02
	.define _STK01	STK01
	.define _STK00	STK00

;--------------------------------------------------------
; global definitions
;--------------------------------------------------------
;--------------------------------------------------------
; absolute symbol definitions
;--------------------------------------------------------
;--------------------------------------------------------
; compiler-defined variables
;--------------------------------------------------------
UDL_lcd1602_0	.udata
r0x103E	.res	1
UDL_lcd1602_1	.udata
r0x1018	.res	1
UDL_lcd1602_2	.udata
r0x103F	.res	1
UDL_lcd1602_3	.udata
r0x1040	.res	1
UDL_lcd1602_4	.udata
r0x103B	.res	1
UDL_lcd1602_5	.udata
r0x103A	.res	1
UDL_lcd1602_6	.udata
r0x1039	.res	1
UDL_lcd1602_7	.udata
r0x103C	.res	1
UDL_lcd1602_8	.udata
r0x1031	.res	1
UDL_lcd1602_9	.udata
r0x1030	.res	1
UDL_lcd1602_10	.udata
r0x102F	.res	1
UDL_lcd1602_11	.udata
r0x102E	.res	1
UDL_lcd1602_12	.udata
r0x1032	.res	1
UDL_lcd1602_13	.udata
r0x1033	.res	1
UDL_lcd1602_14	.udata
r0x1037	.res	1
UDL_lcd1602_15	.udata
r0x1038	.res	1
UDL_lcd1602_16	.udata
r0x1028	.res	1
UDL_lcd1602_17	.udata
r0x1027	.res	1
UDL_lcd1602_18	.udata
r0x1026	.res	1
UDL_lcd1602_19	.udata
r0x1025	.res	1
UDL_lcd1602_20	.udata
r0x102C	.res	1
UDL_lcd1602_21	.udata
r0x102B	.res	1
UDL_lcd1602_22	.udata
r0x102A	.res	1
UDL_lcd1602_23	.udata
r0x1029	.res	1
UDL_lcd1602_24	.udata
r0x101C	.res	1
UDL_lcd1602_25	.udata
r0x101B	.res	1
UDL_lcd1602_26	.udata
r0x101A	.res	1
UDL_lcd1602_27	.udata
r0x1019	.res	1
UDL_lcd1602_28	.udata
r0x101D	.res	1
UDL_lcd1602_29	.udata
r0x101E	.res	1
UDL_lcd1602_30	.udata
r0x1024	.res	1
UDL_lcd1602_31	.udata
r0x1023	.res	1
UDL_lcd1602_32	.udata
_LCD1602_PrintInteger_buf_1_1	.res	12
UDL_lcd1602_33	.udata
_LCD1602_PrintHEX_buf_1_1	.res	12
;--------------------------------------------------------
; initialized data
;--------------------------------------------------------
;--------------------------------------------------------
; overlayable items in internal ram 
;--------------------------------------------------------
;	.udata_ovr


func._LCD1602_PrintHEX	.code
;***
;  PostBlock Stats: dbName = C
;***
;entry:  _LCD1602_PrintHEX	;Function start
; 2 exit points
;has an exit
;functions called:
;   __modslong
;   __divslong
;   _LCD1602Write
;   __modslong
;   __divslong
;   _LCD1602Write
;19 compiler assigned registers:
;   r0x1019
;   STK00
;   r0x101A
;   STK01
;   r0x101B
;   STK02
;   r0x101C
;   r0x101D
;   r0x101E
;   STK06
;   STK05
;   STK04
;   STK03
;   r0x101F
;   r0x1020
;   r0x1021
;   r0x1022
;   r0x1023
;   r0x1024
;; Starting PostCode block
	.def _LCD1602_PrintHEX_function_begin, debug, value=$

;	::->op : LABEL
;	::->op : FUNCTION
_LCD1602_PrintHEX	;Function start
; 2 exit points
;	::->op : RECEIVE
	.line	150; "../lcd1602.c"	void LCD1602_PrintHEX(long data_out)
	BANKSEL	r0x1019
	MOV	r0x1019, R0
	BANKSEL	STK00
	MOVZ	R0, STK00
	BANKSEL	r0x101A
	MOV	r0x101A, R0
	BANKSEL	STK01
	MOVZ	R0, STK01
	BANKSEL	r0x101B
	MOV	r0x101B, R0
	BANKSEL	STK02
	MOVZ	R0, STK02
	BANKSEL	r0x101C
	MOV	r0x101C, R0
;	::->op : =
	.line	156; "../lcd1602.c"	while(data_out > 0)
	BANKSEL	r0x101D
	CLR	r0x101D
;	::->op : LABEL
;	::->op : >
;swapping arguments (AOP_TYPEs 1/2)
;signed compare: left >= lit(0x1=1), size=4, mask=ffffffff
_00054_DS_
	BANKSEL	r0x1019
	MOVZ	R0, r0x1019
	ADD	R0,# 0x80
	ADD	R0,# 0x80
;comparing bytes at offset 3
	JB	PSW, 2
	JMP	_00079_DS_
	MOV	R0,# 0x00
	BANKSEL	r0x101A
	SUB	R0, r0x101A
	JB	PSW, 2
	JMP	_00079_DS_
	MOV	R0,# 0x00
	BANKSEL	r0x101B
	SUB	R0, r0x101B
	JB	PSW, 2
	JMP	_00079_DS_
	MOV	R0,# 0x01
	BANKSEL	r0x101C
	SUB	R0, r0x101C
_00079_DS_
	JB	PSW, 0
	JMP	_00077_DS_
;	::->op : +
	.line	158; "../lcd1602.c"	buf[i]=data_out%16;
	BANKSEL	r0x101D
	MOV	R0, r0x101D
	ADD	R0,# (_LCD1602_PrintHEX_buf_1_1 + 0)
	BANKSEL	r0x101E
	MOV	r0x101E, R0
;	::->op : SEND
;	::->op : SEND
;	::->op : CALL
	MOV	R0,# 0x10
	BANKSEL	STK06
	MOV	STK06, R0
	MOV	R0,# 0x00
	BANKSEL	STK05
	MOV	STK05, R0
	MOV	R0,# 0x00
	BANKSEL	STK04
	MOV	STK04, R0
	MOV	R0,# 0x00
	BANKSEL	STK03
	MOV	STK03, R0
	BANKSEL	r0x101C
	MOVZ	R0, r0x101C
	BANKSEL	STK02
	MOV	STK02, R0
	BANKSEL	r0x101B
	MOVZ	R0, r0x101B
	BANKSEL	STK01
	MOV	STK01, R0
	BANKSEL	r0x101A
	MOVZ	R0, r0x101A
	BANKSEL	STK00
	MOV	STK00, R0
	BANKSEL	r0x1019
	MOVZ	R0, r0x1019
	PAGESEL	__modslong
	CALL	__modslong
	PAGESEL	$
;;1	MOV	r0x101F, R0
	BANKSEL	STK00
	MOVZ	R0, STK00
;;1	MOV	r0x1020, R0
	BANKSEL	STK01
	MOVZ	R0, STK01
;;1	MOV	r0x1021, R0
	BANKSEL	STK02
	MOVZ	R0, STK02
;;1	MOV	r0x1022, R0
	BANKSEL	r0x1023
	MOV	r0x1023, R0
;	::->op : CAST
;;105	MOVZ	R0, r0x1022
;	::->op :*  =
	BANKSEL	r0x1023
	MOVZ	R0, r0x1023
	BANKSEL	r0x101E
	MOV	R1, r0x101E
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	ST	[R1], R0
;	::->op : +
	.line	159; "../lcd1602.c"	i++;
	BANKSEL	r0x101D
	INC	r0x101D
;	::->op : SEND
;	::->op : SEND
;	::->op : CALL
	.line	160; "../lcd1602.c"	data_out=data_out/16;
	MOV	R0,# 0x10
	BANKSEL	STK06
	MOV	STK06, R0
	MOV	R0,# 0x00
	BANKSEL	STK05
	MOV	STK05, R0
	MOV	R0,# 0x00
	BANKSEL	STK04
	MOV	STK04, R0
	MOV	R0,# 0x00
	BANKSEL	STK03
	MOV	STK03, R0
	BANKSEL	r0x101C
	MOVZ	R0, r0x101C
	BANKSEL	STK02
	MOV	STK02, R0
	BANKSEL	r0x101B
	MOVZ	R0, r0x101B
	BANKSEL	STK01
	MOV	STK01, R0
	BANKSEL	r0x101A
	MOVZ	R0, r0x101A
	BANKSEL	STK00
	MOV	STK00, R0
	BANKSEL	r0x1019
	MOVZ	R0, r0x1019
	PAGESEL	__divslong
	CALL	__divslong
	PAGESEL	$
	BANKSEL	r0x1019
	MOV	r0x1019, R0
	BANKSEL	STK00
	MOVZ	R0, STK00
	BANKSEL	r0x101A
	MOV	r0x101A, R0
	BANKSEL	STK01
	MOVZ	R0, STK01
	BANKSEL	r0x101B
	MOV	r0x101B, R0
	BANKSEL	STK02
	MOVZ	R0, STK02
	BANKSEL	r0x101C
	MOV	r0x101C, R0
;	::->op : GOTO
	JMP	_00054_DS_
;	::->op : LABEL
;	::->op : =
_00077_DS_
	BANKSEL	r0x101D
	MOVZ	R0, r0x101D
	BANKSEL	r0x101C
	MOV	r0x101C, R0
;	::->op : >
;swapping arguments (AOP_TYPEs 1/2)
;unsigned compare: left >= lit(0x4=4), size=1
	.line	162; "../lcd1602.c"	switch (i)
	MOV	R0,# 0x04
	BANKSEL	r0x101D
	SUB	R0, r0x101D
;comparing bytes at offset 0
	JNB	PSW, 0
	JMP	_00066_DS_
;	::->op : JUMPTABLE
	MOV	R0,#high _00081_DS_
	MOV	PCH, R0
	MOV	R0,#_00081_DS_
	BANKSEL	r0x101C
	ADD	R0, r0x101C
	JNB	PSW, 0
	INC	PCH
	MOV	PCL, R0
_00081_DS_
	JMP	_00057_DS_
	JMP	_00058_DS_
	JMP	_00059_DS_
	JMP	_00060_DS_
;	::->op : LABEL
;	::->op :*  =
_00057_DS_
	.line	166; "../lcd1602.c"	buf[0]=0;
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	CLR	 (_LCD1602_PrintHEX_buf_1_1 + 0)
;	::->op :*  =
	.line	167; "../lcd1602.c"	buf[1]=0;
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	CLR	 (_LCD1602_PrintHEX_buf_1_1 + 1)
;	::->op :*  =
	.line	168; "../lcd1602.c"	buf[2]=0;
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	CLR	 (_LCD1602_PrintHEX_buf_1_1 + 2)
;	::->op :*  =
	.line	169; "../lcd1602.c"	buf[3]=0;
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	CLR	 (_LCD1602_PrintHEX_buf_1_1 + 3)
;	::->op : =
	.line	170; "../lcd1602.c"	i=4;
	MOV	R0,# 0x04
	BANKSEL	r0x101C
	MOV	r0x101C, R0
;	::->op : GOTO
	.line	171; "../lcd1602.c"	break;
	JMP	_00066_DS_
;	::->op : LABEL
;	::->op :*  =
_00058_DS_
	.line	175; "../lcd1602.c"	buf[1]=0;
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	CLR	 (_LCD1602_PrintHEX_buf_1_1 + 1)
;	::->op :*  =
	.line	176; "../lcd1602.c"	buf[2]=0;
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	CLR	 (_LCD1602_PrintHEX_buf_1_1 + 2)
;	::->op :*  =
	.line	177; "../lcd1602.c"	buf[3]=0;
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	CLR	 (_LCD1602_PrintHEX_buf_1_1 + 3)
;	::->op : =
	.line	178; "../lcd1602.c"	i=4;
	MOV	R0,# 0x04
	BANKSEL	r0x101C
	MOV	r0x101C, R0
;	::->op : GOTO
	.line	179; "../lcd1602.c"	break;
	JMP	_00066_DS_
;	::->op : LABEL
;	::->op :*  =
_00059_DS_
	.line	183; "../lcd1602.c"	buf[2]=0;
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	CLR	 (_LCD1602_PrintHEX_buf_1_1 + 2)
;	::->op :*  =
	.line	184; "../lcd1602.c"	buf[3]=0;
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	CLR	 (_LCD1602_PrintHEX_buf_1_1 + 3)
;	::->op : =
	.line	185; "../lcd1602.c"	i=4;
	MOV	R0,# 0x04
	BANKSEL	r0x101C
	MOV	r0x101C, R0
;	::->op : GOTO
	.line	186; "../lcd1602.c"	break;
	JMP	_00066_DS_
;	::->op : LABEL
;	::->op :*  =
_00060_DS_
	.line	190; "../lcd1602.c"	buf[3]=0;
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	CLR	 (_LCD1602_PrintHEX_buf_1_1 + 3)
;	::->op : =
	.line	191; "../lcd1602.c"	i=4;
	MOV	R0,# 0x04
	BANKSEL	r0x101C
	MOV	r0x101C, R0
;	::->op : LABEL
;	::->op : =
;	::->op : LABEL
;	::->op : =
_00066_DS_
	.line	199; "../lcd1602.c"	while(i--)
	BANKSEL	r0x101C
	MOVZ	R0, r0x101C
	BANKSEL	r0x101B
	MOV	r0x101B, R0
;	::->op : -
	BANKSEL	r0x101C
	DEC	r0x101C
;	::->op : IFX
	MOV	R0,# 0x00
	BANKSEL	r0x101B
	ORL	R0, r0x101B
	JNB	PSW, 2
	JMP	_00069_DS_
;	::->op : +
	.line	201; "../lcd1602.c"	if(buf[i]<10)
	BANKSEL	r0x101C
	MOV	R0, r0x101C
	ADD	R0,# (_LCD1602_PrintHEX_buf_1_1 + 0)
	BANKSEL	r0x101B
	MOV	r0x101B, R0
;	::->op : GET_VALUE_AT_ADDRESS
	BANKSEL	r0x101B
	MOV	R1, r0x101B
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	LD	R0, [R1]
	BANKSEL	r0x1019
	MOV	r0x1019, R0
;	::->op : <
;signed compare: left < lit(0xA=10), size=1, mask=ff
	BANKSEL	r0x1019
	MOVZ	R0, r0x1019
	ADD	R0,# 0x80
	ADD	R0,# 0x76
;comparing bytes at offset 0
	JNB	PSW, 0
	JMP	_00064_DS_
;	::->op : +
	.line	202; "../lcd1602.c"	buf[i]+='0';
	BANKSEL	r0x101C
	MOV	R0, r0x101C
	ADD	R0,# (_LCD1602_PrintHEX_buf_1_1 + 0)
	BANKSEL	r0x101B
	MOV	r0x101B, R0
;	::->op : +
	BANKSEL	r0x101C
	MOV	R0, r0x101C
	ADD	R0,# (_LCD1602_PrintHEX_buf_1_1 + 0)
	BANKSEL	r0x1019
	MOV	r0x1019, R0
;	::->op : GET_VALUE_AT_ADDRESS
	BANKSEL	r0x1019
	MOV	R1, r0x1019
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	LD	R0, [R1]
	BANKSEL	r0x101E
	MOV	r0x101E, R0
;	::->op : +
	MOV	R0,# 0x30
	BANKSEL	r0x101E
	ADD	R0, r0x101E
	BANKSEL	r0x1019
	MOV	r0x1019, R0
;	::->op :*  =
	BANKSEL	r0x1019
	MOVZ	R0, r0x1019
	BANKSEL	r0x101B
	MOV	R1, r0x101B
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	ST	[R1], R0
;	::->op : GOTO
	JMP	_00065_DS_
;	::->op : LABEL
;	::->op : +
_00064_DS_
	.line	204; "../lcd1602.c"	buf[i]=buf[i]-10+'A';
	BANKSEL	r0x101C
	MOV	R0, r0x101C
	ADD	R0,# (_LCD1602_PrintHEX_buf_1_1 + 0)
	BANKSEL	r0x101B
	MOV	r0x101B, R0
;	::->op : +
	BANKSEL	r0x101C
	MOV	R0, r0x101C
	ADD	R0,# (_LCD1602_PrintHEX_buf_1_1 + 0)
	BANKSEL	r0x1019
	MOV	r0x1019, R0
;	::->op : GET_VALUE_AT_ADDRESS
	BANKSEL	r0x1019
	MOV	R1, r0x1019
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	LD	R0, [R1]
	BANKSEL	r0x1024
	MOV	r0x1024, R0
;	::->op : +
	MOV	R0,# 0x37
	BANKSEL	r0x1024
	ADD	R0, r0x1024
	BANKSEL	r0x1019
	MOV	r0x1019, R0
;	::->op :*  =
	BANKSEL	r0x1019
	MOVZ	R0, r0x1019
	BANKSEL	r0x101B
	MOV	R1, r0x101B
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	ST	[R1], R0
;	::->op : LABEL
;	::->op : +
_00065_DS_
	.line	205; "../lcd1602.c"	LCD1602Write(buf[i]);
	BANKSEL	r0x101C
	MOV	R0, r0x101C
	ADD	R0,# (_LCD1602_PrintHEX_buf_1_1 + 0)
	BANKSEL	r0x101B
	MOV	r0x101B, R0
;	::->op : GET_VALUE_AT_ADDRESS
	BANKSEL	r0x101B
	MOV	R1, r0x101B
	BANKSEL	_LCD1602_PrintHEX_buf_1_1
	LD	R0, [R1]
	BANKSEL	r0x1019
	MOV	r0x1019, R0
;	::->op : CAST
;;112	MOVZ	R0, r0x1019
;	::->op : SEND
;	::->op : CALL
;;111	MOVZ	R0, r0x101B
	BANKSEL	r0x1019
	MOVZ	R0, r0x1019
	BANKSEL	r0x101B
	MOV	r0x101B, R0
	PAGESEL	_LCD1602Write
	CALL	_LCD1602Write
	PAGESEL	$
;	::->op : GOTO
	JMP	_00066_DS_
;	::->op : LABEL
;	::->op : ENDFUNCTION
_00069_DS_
	CRET	
	.def _LCD1602_PrintHEX_function_end, debug, value=$

; exit point of _LCD1602_PrintHEX



func._LCD1602_PrintHEX_TWO	.code
;***
;  PostBlock Stats: dbName = C
;***
;entry:  _LCD1602_PrintHEX_TWO	;Function start
; 2 exit points
;has an exit
;functions called:
;   __modslong
;   __divslong
;   _LCD1602Write
;   _LCD1602Write
;   __modslong
;   __divslong
;   _LCD1602Write
;   _LCD1602Write
;16 compiler assigned registers:
;   r0x1025
;   STK00
;   r0x1026
;   STK01
;   r0x1027
;   STK02
;   r0x1028
;   STK06
;   STK05
;   STK04
;   STK03
;   r0x1029
;   r0x102A
;   r0x102B
;   r0x102C
;   r0x102D
;; Starting PostCode block
	.def _LCD1602_PrintHEX_TWO_function_begin, debug, value=$

;	::->op : LABEL
;	::->op : FUNCTION
_LCD1602_PrintHEX_TWO	;Function start
; 2 exit points
;	::->op : RECEIVE
	.line	130; "../lcd1602.c"	void LCD1602_PrintHEX_TWO(long data_out)
	BANKSEL	r0x1025
	MOV	r0x1025, R0
	BANKSEL	STK00
	MOVZ	R0, STK00
	BANKSEL	r0x1026
	MOV	r0x1026, R0
	BANKSEL	STK01
	MOVZ	R0, STK01
	BANKSEL	r0x1027
	MOV	r0x1027, R0
	BANKSEL	STK02
	MOVZ	R0, STK02
	BANKSEL	r0x1028
	MOV	r0x1028, R0
;	::->op : SEND
;	::->op : SEND
;	::->op : CALL
	.line	134; "../lcd1602.c"	l=data_out%16;
	MOV	R0,# 0x10
	BANKSEL	STK06
	MOV	STK06, R0
	MOV	R0,# 0x00
	BANKSEL	STK05
	MOV	STK05, R0
	MOV	R0,# 0x00
	BANKSEL	STK04
	MOV	STK04, R0
	MOV	R0,# 0x00
	BANKSEL	STK03
	MOV	STK03, R0
	BANKSEL	r0x1028
	MOVZ	R0, r0x1028
	BANKSEL	STK02
	MOV	STK02, R0
	BANKSEL	r0x1027
	MOVZ	R0, r0x1027
	BANKSEL	STK01
	MOV	STK01, R0
	BANKSEL	r0x1026
	MOVZ	R0, r0x1026
	BANKSEL	STK00
	MOV	STK00, R0
	BANKSEL	r0x1025
	MOVZ	R0, r0x1025
	PAGESEL	__modslong
	CALL	__modslong
	PAGESEL	$
	BANKSEL	r0x1029
	MOV	r0x1029, R0
	BANKSEL	STK00
	MOVZ	R0, STK00
	BANKSEL	r0x102A
	MOV	r0x102A, R0
	BANKSEL	STK01
	MOVZ	R0, STK01
	BANKSEL	r0x102B
	MOV	r0x102B, R0
	BANKSEL	STK02
	MOVZ	R0, STK02
	BANKSEL	r0x102C
	MOV	r0x102C, R0
;	::->op : SEND
;	::->op : SEND
;	::->op : CALL
	.line	136; "../lcd1602.c"	h=data_out/16;
	MOV	R0,# 0x10
	BANKSEL	STK06
	MOV	STK06, R0
	MOV	R0,# 0x00
	BANKSEL	STK05
	MOV	STK05, R0
	MOV	R0,# 0x00
	BANKSEL	STK04
	MOV	STK04, R0
	MOV	R0,# 0x00
	BANKSEL	STK03
	MOV	STK03, R0
	BANKSEL	r0x1028
	MOVZ	R0, r0x1028
	BANKSEL	STK02
	MOV	STK02, R0
	BANKSEL	r0x1027
	MOVZ	R0, r0x1027
	BANKSEL	STK01
	MOV	STK01, R0
	BANKSEL	r0x1026
	MOVZ	R0, r0x1026
	BANKSEL	STK00
	MOV	STK00, R0
	BANKSEL	r0x1025
	MOVZ	R0, r0x1025
	PAGESEL	__divslong
	CALL	__divslong
	PAGESEL	$
	BANKSEL	r0x1025
	MOV	r0x1025, R0
	BANKSEL	STK00
	MOVZ	R0, STK00
	BANKSEL	r0x1026
	MOV	r0x1026, R0
	BANKSEL	STK01
	MOVZ	R0, STK01
	BANKSEL	r0x1027
	MOV	r0x1027, R0
	BANKSEL	STK02
	MOVZ	R0, STK02
	BANKSEL	r0x1028
	MOV	r0x1028, R0
;	::->op : <
;signed compare: left < lit(0xA=10), size=4, mask=ffffffff
	.line	138; "../lcd1602.c"	if(h<10)
	BANKSEL	r0x1025
	MOVZ	R0, r0x1025
	ADD	R0,# 0x80
	ADD	R0,# 0x80
;comparing bytes at offset 3
	JB	PSW, 2
	JMP	_00052_DS_
	MOV	R0,# 0x00
	BANKSEL	r0x1026
	SUB	R0, r0x1026
	JB	PSW, 2
	JMP	_00052_DS_
	MOV	R0,# 0x00
	BANKSEL	r0x1027
	SUB	R0, r0x1027
	JB	PSW, 2
	JMP	_00052_DS_
	MOV	R0,# 0x0a
	BANKSEL	r0x1028
	SUB	R0, r0x1028
_00052_DS_
	JNB	PSW, 0
	JMP	_00043_DS_
;	::->op : +
	.line	139; "../lcd1602.c"	h+='0';
	MOV	R0,# 0x30
	BANKSEL	r0x1028
	ADD	r0x1028, R0
	JB	PSW, 0
	JMP	_00083_DS_
	BANKSEL	r0x1027
	INC	r0x1027
_00083_DS_
	JB	PSW, 2
	JMP	_00084_DS_
	BANKSEL	r0x1026
	INC	r0x1026
_00084_DS_
	JB	PSW, 2
	JMP	_00085_DS_
	BANKSEL	r0x1025
	INC	r0x1025
;	::->op : GOTO
_00085_DS_
	JMP	_00088_DS_
;	::->op : LABEL
;	::->op : +
_00043_DS_
	.line	141; "../lcd1602.c"	h=h-10+'A';
	MOV	R0,# 0x37
	BANKSEL	r0x1028
	ADD	r0x1028, R0
	JB	PSW, 0
	JMP	_00086_DS_
	BANKSEL	r0x1027
	INC	r0x1027
_00086_DS_
	JB	PSW, 2
	JMP	_00087_DS_
	BANKSEL	r0x1026
	INC	r0x1026
_00087_DS_
	JB	PSW, 2
	JMP	_00088_DS_
	BANKSEL	r0x1025
	INC	r0x1025
;	::->op : LABEL
;	::->op : CAST
;;104	MOVZ	R0, r0x1028
;;102	MOV	r0x102D, R0
;	::->op : SEND
;	::->op : CALL
;;103	MOVZ	R0, r0x102D
_00088_DS_
	.line	142; "../lcd1602.c"	LCD1602Write(h);
	BANKSEL	r0x1028
	MOVZ	R0, r0x1028
	PAGESEL	_LCD1602Write
	CALL	_LCD1602Write
	PAGESEL	$
;	::->op : <
;signed compare: left < lit(0xA=10), size=4, mask=ffffffff
	.line	144; "../lcd1602.c"	if(l<10)
	BANKSEL	r0x1029
	MOVZ	R0, r0x1029
	ADD	R0,# 0x80
	ADD	R0,# 0x80
;comparing bytes at offset 3
	JB	PSW, 2
	JMP	_00053_DS_
	MOV	R0,# 0x00
	BANKSEL	r0x102A
	SUB	R0, r0x102A
	JB	PSW, 2
	JMP	_00053_DS_
	MOV	R0,# 0x00
	BANKSEL	r0x102B
	SUB	R0, r0x102B
	JB	PSW, 2
	JMP	_00053_DS_
	MOV	R0,# 0x0a
	BANKSEL	r0x102C
	SUB	R0, r0x102C
_00053_DS_
	JNB	PSW, 0
	JMP	_00046_DS_
;	::->op : +
	.line	145; "../lcd1602.c"	l+='0';
	MOV	R0,# 0x30
	BANKSEL	r0x102C
	ADD	r0x102C, R0
	JB	PSW, 0
	JMP	_00089_DS_
	BANKSEL	r0x102B
	INC	r0x102B
_00089_DS_
	JB	PSW, 2
	JMP	_00090_DS_
	BANKSEL	r0x102A
	INC	r0x102A
_00090_DS_
	JB	PSW, 2
	JMP	_00091_DS_
	BANKSEL	r0x1029
	INC	r0x1029
;	::->op : GOTO
_00091_DS_
	JMP	_00094_DS_
;	::->op : LABEL
;	::->op : +
_00046_DS_
	.line	147; "../lcd1602.c"	l=l-10+'A';
	MOV	R0,# 0x37
	BANKSEL	r0x102C
	ADD	r0x102C, R0
	JB	PSW, 0
	JMP	_00092_DS_
	BANKSEL	r0x102B
	INC	r0x102B
_00092_DS_
	JB	PSW, 2
	JMP	_00093_DS_
	BANKSEL	r0x102A
	INC	r0x102A
_00093_DS_
	JB	PSW, 2
	JMP	_00094_DS_
	BANKSEL	r0x1029
	INC	r0x1029
;	::->op : LABEL
;	::->op : CAST
;;110	MOVZ	R0, r0x102C
;	::->op : SEND
;	::->op : CALL
;;109	MOVZ	R0, r0x1028
_00094_DS_
	.line	148; "../lcd1602.c"	LCD1602Write(l);	
	BANKSEL	r0x102C
	MOVZ	R0, r0x102C
	BANKSEL	r0x1028
	MOV	r0x1028, R0
	PAGESEL	_LCD1602Write
	CALL	_LCD1602Write
	PAGESEL	$
;	::->op : LABEL
;	::->op : ENDFUNCTION
	CRET	
	.def _LCD1602_PrintHEX_TWO_function_end, debug, value=$

; exit point of _LCD1602_PrintHEX_TWO



func._LCD1602_PrintInteger	.code
;***
;  PostBlock Stats: dbName = C
;***
;entry:  _LCD1602_PrintInteger	;Function start
; 2 exit points
;has an exit
;functions called:
;   _LCD1602Write
;   __modslong
;   __divslong
;   _LCD1602Write
;   _LCD1602Write
;   __modslong
;   __divslong
;   _LCD1602Write
;18 compiler assigned registers:
;   r0x102E
;   STK00
;   r0x102F
;   STK01
;   r0x1030
;   STK02
;   r0x1031
;   r0x1032
;   r0x1033
;   STK06
;   STK05
;   STK04
;   STK03
;   r0x1034
;   r0x1035
;   r0x1036
;   r0x1037
;   r0x1038
;; Starting PostCode block
	.def _LCD1602_PrintInteger_function_begin, debug, value=$

;	::->op : LABEL
;	::->op : FUNCTION
_LCD1602_PrintInteger	;Function start
; 2 exit points
;	::->op : RECEIVE
	.line	107; "../lcd1602.c"	void LCD1602_PrintInteger(long data_out)
	BANKSEL	r0x102E
	MOV	r0x102E, R0
	BANKSEL	STK00
	MOVZ	R0, STK00
	BANKSEL	r0x102F
	MOV	r0x102F, R0
	BANKSEL	STK01
	MOVZ	R0, STK01
	BANKSEL	r0x1030
	MOV	r0x1030, R0
	BANKSEL	STK02
	MOVZ	R0, STK02
	BANKSEL	r0x1031
	MOV	r0x1031, R0
;	::->op : IFX
	.line	111; "../lcd1602.c"	if(data_out==0)
	BANKSEL	r0x1031
	MOVZ	R0, r0x1031
	BANKSEL	r0x1030
	ORL	R0, r0x1030
	BANKSEL	r0x102F
	ORL	R0, r0x102F
	BANKSEL	r0x102E
	ORL	R0, r0x102E
	JB	PSW, 2
	JMP	_00036_DS_
;	::->op : SEND
;	::->op : CALL
	.line	113; "../lcd1602.c"	LCD1602Write('0');
	MOV	R0,# 0x30
	PAGESEL	_LCD1602Write
	CALL	_LCD1602Write
	PAGESEL	$
;	::->op : GOTO
	JMP	_00032_DS_
;	::->op : LABEL
;	::->op : =
_00036_DS_
	.line	117; "../lcd1602.c"	while(data_out > 0)
	BANKSEL	r0x1032
	CLR	r0x1032
;	::->op : LABEL
;	::->op : >
;swapping arguments (AOP_TYPEs 1/2)
;signed compare: left >= lit(0x1=1), size=4, mask=ffffffff
_00023_DS_
	BANKSEL	r0x102E
	MOVZ	R0, r0x102E
	ADD	R0,# 0x80
	ADD	R0,# 0x80
;comparing bytes at offset 3
	JB	PSW, 2
	JMP	_00041_DS_
	MOV	R0,# 0x00
	BANKSEL	r0x102F
	SUB	R0, r0x102F
	JB	PSW, 2
	JMP	_00041_DS_
	MOV	R0,# 0x00
	BANKSEL	r0x1030
	SUB	R0, r0x1030
	JB	PSW, 2
	JMP	_00041_DS_
	MOV	R0,# 0x01
	BANKSEL	r0x1031
	SUB	R0, r0x1031
_00041_DS_
	JB	PSW, 0
	JMP	_00038_DS_
;	::->op : +
	.line	119; "../lcd1602.c"	buf[i]=data_out%10+'0';
	BANKSEL	r0x1032
	MOV	R0, r0x1032
	ADD	R0,# (_LCD1602_PrintInteger_buf_1_1 + 0)
	BANKSEL	r0x1033
	MOV	r0x1033, R0
;	::->op : SEND
;	::->op : SEND
;	::->op : CALL
	MOV	R0,# 0x0a
	BANKSEL	STK06
	MOV	STK06, R0
	MOV	R0,# 0x00
	BANKSEL	STK05
	MOV	STK05, R0
	MOV	R0,# 0x00
	BANKSEL	STK04
	MOV	STK04, R0
	MOV	R0,# 0x00
	BANKSEL	STK03
	MOV	STK03, R0
	BANKSEL	r0x1031
	MOVZ	R0, r0x1031
	BANKSEL	STK02
	MOV	STK02, R0
	BANKSEL	r0x1030
	MOVZ	R0, r0x1030
	BANKSEL	STK01
	MOV	STK01, R0
	BANKSEL	r0x102F
	MOVZ	R0, r0x102F
	BANKSEL	STK00
	MOV	STK00, R0
	BANKSEL	r0x102E
	MOVZ	R0, r0x102E
	PAGESEL	__modslong
	CALL	__modslong
	PAGESEL	$
;;1	MOV	r0x1034, R0
	BANKSEL	STK00
	MOVZ	R0, STK00
;;1	MOV	r0x1035, R0
	BANKSEL	STK01
	MOVZ	R0, STK01
;;1	MOV	r0x1036, R0
	BANKSEL	STK02
	MOVZ	R0, STK02
	BANKSEL	r0x1037
	MOV	r0x1037, R0
	BANKSEL	r0x1038
	MOV	r0x1038, R0
;	::->op : CAST
;;108	MOVZ	R0, r0x1037
;	::->op : +
	MOV	R0,# 0x30
	BANKSEL	r0x1038
	ADD	R0, r0x1038
	BANKSEL	r0x1037
	MOV	r0x1037, R0
;	::->op :*  =
	BANKSEL	r0x1037
	MOVZ	R0, r0x1037
	BANKSEL	r0x1033
	MOV	R1, r0x1033
	BANKSEL	_LCD1602_PrintInteger_buf_1_1
	ST	[R1], R0
;	::->op : +
	.line	120; "../lcd1602.c"	i++;
	BANKSEL	r0x1032
	INC	r0x1032
;	::->op : SEND
;	::->op : SEND
;	::->op : CALL
	.line	121; "../lcd1602.c"	data_out=data_out/10;
	MOV	R0,# 0x0a
	BANKSEL	STK06
	MOV	STK06, R0
	MOV	R0,# 0x00
	BANKSEL	STK05
	MOV	STK05, R0
	MOV	R0,# 0x00
	BANKSEL	STK04
	MOV	STK04, R0
	MOV	R0,# 0x00
	BANKSEL	STK03
	MOV	STK03, R0
	BANKSEL	r0x1031
	MOVZ	R0, r0x1031
	BANKSEL	STK02
	MOV	STK02, R0
	BANKSEL	r0x1030
	MOVZ	R0, r0x1030
	BANKSEL	STK01
	MOV	STK01, R0
	BANKSEL	r0x102F
	MOVZ	R0, r0x102F
	BANKSEL	STK00
	MOV	STK00, R0
	BANKSEL	r0x102E
	MOVZ	R0, r0x102E
	PAGESEL	__divslong
	CALL	__divslong
	PAGESEL	$
	BANKSEL	r0x102E
	MOV	r0x102E, R0
	BANKSEL	STK00
	MOVZ	R0, STK00
	BANKSEL	r0x102F
	MOV	r0x102F, R0
	BANKSEL	STK01
	MOVZ	R0, STK01
	BANKSEL	r0x1030
	MOV	r0x1030, R0
	BANKSEL	STK02
	MOVZ	R0, STK02
	BANKSEL	r0x1031
	MOV	r0x1031, R0
;	::->op : GOTO
	JMP	_00023_DS_
;	::->op : LABEL
;	::->op : =
_00038_DS_
	.line	123; "../lcd1602.c"	while(i--)
	BANKSEL	r0x1032
	MOVZ	R0, r0x1032
	BANKSEL	r0x1031
	MOV	r0x1031, R0
;	::->op : LABEL
;	::->op : =
_00026_DS_
	BANKSEL	r0x1031
	MOVZ	R0, r0x1031
	BANKSEL	r0x1030
	MOV	r0x1030, R0
;	::->op : -
	BANKSEL	r0x1031
	DEC	r0x1031
;	::->op : IFX
	MOV	R0,# 0x00
	BANKSEL	r0x1030
	ORL	R0, r0x1030
	JNB	PSW, 2
	JMP	_00032_DS_
;	::->op : +
	.line	125; "../lcd1602.c"	LCD1602Write(buf[i]);
	BANKSEL	r0x1031
	MOV	R0, r0x1031
	ADD	R0,# (_LCD1602_PrintInteger_buf_1_1 + 0)
	BANKSEL	r0x1030
	MOV	r0x1030, R0
;	::->op : GET_VALUE_AT_ADDRESS
	BANKSEL	r0x1030
	MOV	R1, r0x1030
	BANKSEL	_LCD1602_PrintInteger_buf_1_1
	LD	R0, [R1]
	BANKSEL	r0x102E
	MOV	r0x102E, R0
;	::->op : CAST
;;107	MOVZ	R0, r0x102E
;	::->op : SEND
;	::->op : CALL
;;106	MOVZ	R0, r0x1030
	BANKSEL	r0x102E
	MOVZ	R0, r0x102E
	BANKSEL	r0x1030
	MOV	r0x1030, R0
	PAGESEL	_LCD1602Write
	CALL	_LCD1602Write
	PAGESEL	$
;	::->op : GOTO
	JMP	_00026_DS_
;	::->op : LABEL
;	::->op : ENDFUNCTION
_00032_DS_
	CRET	
	.def _LCD1602_PrintInteger_function_end, debug, value=$

; exit point of _LCD1602_PrintInteger



func._LCD1602_PrintString	.code
;***
;  PostBlock Stats: dbName = C
;***
;entry:  _LCD1602_PrintString	;Function start
; 2 exit points
;has an exit
;functions called:
;   __gptrget1
;   __gptrget1
;   _LCD1602Write
;   __gptrget1
;   __gptrget1
;   _LCD1602Write
;7 compiler assigned registers:
;   r0x1039
;   STK00
;   r0x103A
;   STK01
;   r0x103B
;   r0x103C
;   r0x103D
;; Starting PostCode block
	.def _LCD1602_PrintString_function_begin, debug, value=$

;	::->op : LABEL
;	::->op : FUNCTION
_LCD1602_PrintString	;Function start
; 2 exit points
;	::->op : RECEIVE
	.line	98; "../lcd1602.c"	void LCD1602_PrintString(const char *s)
	BANKSEL	r0x1039
	MOV	r0x1039, R0
	BANKSEL	STK00
	MOVZ	R0, STK00
	BANKSEL	r0x103A
	MOV	r0x103A, R0
	BANKSEL	STK01
	MOVZ	R0, STK01
	BANKSEL	r0x103B
	MOV	r0x103B, R0
;	::->op : =
;	::->op : LABEL
;	::->op : GET_VALUE_AT_ADDRESS
_00015_DS_
	.line	100; "../lcd1602.c"	while(*s)
	BANKSEL	r0x103B
	MOVZ	R0, r0x103B
	BANKSEL	STK01
	MOV	STK01, R0
	BANKSEL	r0x103A
	MOVZ	R0, r0x103A
	BANKSEL	STK00
	MOV	STK00, R0
	BANKSEL	r0x1039
	MOVZ	R0, r0x1039
	PAGESEL	__gptrget1
	CALL	__gptrget1
	PAGESEL	$
	BANKSEL	r0x103C
	MOV	r0x103C, R0
;	::->op : IFX
	MOV	R0,# 0x00
	BANKSEL	r0x103C
	ORL	R0, r0x103C
	JNB	PSW, 2
	JMP	_00018_DS_
;	::->op : GET_VALUE_AT_ADDRESS
	.line	102; "../lcd1602.c"	LCD1602Write(*s);
	BANKSEL	r0x103B
	MOVZ	R0, r0x103B
	BANKSEL	STK01
	MOV	STK01, R0
	BANKSEL	r0x103A
	MOVZ	R0, r0x103A
	BANKSEL	STK00
	MOV	STK00, R0
	BANKSEL	r0x1039
	MOVZ	R0, r0x1039
	PAGESEL	__gptrget1
	CALL	__gptrget1
	PAGESEL	$
	BANKSEL	r0x103C
	MOV	r0x103C, R0
;	::->op : CAST
;;101	MOVZ	R0, r0x103C
;;99	MOV	r0x103D, R0
;	::->op : SEND
;	::->op : CALL
;;100	MOVZ	R0, r0x103D
	BANKSEL	r0x103C
	MOVZ	R0, r0x103C
	PAGESEL	_LCD1602Write
	CALL	_LCD1602Write
	PAGESEL	$
;	::->op : +
	.line	103; "../lcd1602.c"	s++;
	BANKSEL	r0x103B
	INC	r0x103B
	JB	PSW, 2
	JMP	_00095_DS_
	BANKSEL	r0x103A
	INC	r0x103A
_00095_DS_
	JB	PSW, 2
	JMP	_00096_DS_
	BANKSEL	r0x1039
	INC	r0x1039
;	::->op : GOTO
_00096_DS_
	JMP	_00015_DS_
;	::->op : LABEL
;	::->op : ENDFUNCTION
_00018_DS_
	CRET	
	.def _LCD1602_PrintString_function_end, debug, value=$

; exit point of _LCD1602_PrintString



func._LCD1602_Clear	.code
;***
;  PostBlock Stats: dbName = C
;***
;entry:  _LCD1602_Clear	;Function start
; 2 exit points
;has an exit
;functions called:
;   _LCD1602WriteCmd
;   _delay_ms
;   _LCD1602WriteCmd
;   _delay_ms
;1 compiler assigned register :
;   STK00
;; Starting PostCode block
	.def _LCD1602_Clear_function_begin, debug, value=$

;	::->op : LABEL
;	::->op : FUNCTION
_LCD1602_Clear	;Function start
; 2 exit points
;	::->op : SEND
;	::->op : CALL
	.line	93; "../lcd1602.c"	LCD1602WriteCmd(DISP_CLR);
	MOV	R0,# 0x01
	PAGESEL	_LCD1602WriteCmd
	CALL	_LCD1602WriteCmd
	PAGESEL	$
;	::->op : SEND
;	::->op : CALL
	.line	94; "../lcd1602.c"	delay_ms(1);
	MOV	R0,# 0x01
	BANKSEL	STK00
	MOV	STK00, R0
	MOV	R0,# 0x00
	PAGESEL	_delay_ms
	CALL	_delay_ms
	PAGESEL	$
;	::->op : LABEL
;	::->op : ENDFUNCTION
	CRET	
	.def _LCD1602_Clear_function_end, debug, value=$

; exit point of _LCD1602_Clear



func._LCD1602_setxy	.code
;***
;  PostBlock Stats: dbName = C
;***
;entry:  _LCD1602_setxy	;Function start
; 2 exit points
;has an exit
;functions called:
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;3 compiler assigned registers:
;   r0x103F
;   STK00
;   r0x1040
;; Starting PostCode block
	.def _LCD1602_setxy_function_begin, debug, value=$

;	::->op : LABEL
;	::->op : FUNCTION
_LCD1602_setxy	;Function start
; 2 exit points
;	::->op : RECEIVE
	.line	78; "../lcd1602.c"	void LCD1602_setxy(unsigned char x,unsigned char y)
	BANKSEL	r0x103F
	MOV	r0x103F, R0
;	::->op : RECEIVE
	BANKSEL	STK00
	MOVZ	R0, STK00
	BANKSEL	r0x1040
	MOV	r0x1040, R0
;	::->op : IFX
	.line	80; "../lcd1602.c"	if(x==0)
	MOV	R0,# 0x00
	BANKSEL	r0x103F
	ORL	R0, r0x103F
	JB	PSW, 2
	JMP	_00008_DS_
;	::->op : +
	.line	82; "../lcd1602.c"	LCD1602WriteCmd(0x80+y);
	MOV	R0,# 0x80
	BANKSEL	r0x1040
	ADD	R0, r0x1040
	BANKSEL	r0x103F
	MOV	r0x103F, R0
;	::->op : SEND
;	::->op : CALL
	BANKSEL	r0x103F
	MOVZ	R0, r0x103F
	PAGESEL	_LCD1602WriteCmd
	CALL	_LCD1602WriteCmd
	PAGESEL	$
;	::->op : GOTO
	JMP	_00010_DS_
;	::->op : LABEL
;	::->op : +
_00008_DS_
	.line	86; "../lcd1602.c"	LCD1602WriteCmd(0xc0+y);
	MOV	R0,# 0xc0
	BANKSEL	r0x1040
	ADD	r0x1040, R0
;	::->op : SEND
;	::->op : CALL
	BANKSEL	r0x1040
	MOVZ	R0, r0x1040
	PAGESEL	_LCD1602WriteCmd
	CALL	_LCD1602WriteCmd
	PAGESEL	$
;	::->op : LABEL
;	::->op : ENDFUNCTION
_00010_DS_
	CRET	
	.def _LCD1602_setxy_function_end, debug, value=$

; exit point of _LCD1602_setxy



func._LCD1602_Init	.code
;***
;  PostBlock Stats: dbName = C
;***
;entry:  _LCD1602_Init	;Function start
; 2 exit points
;has an exit
;functions called:
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;   _LCD1602WriteCmd
;; Starting PostCode block
	.def _LCD1602_Init_function_begin, debug, value=$

;	::->op : LABEL
;	::->op : FUNCTION
_LCD1602_Init	;Function start
; 2 exit points
;	::->op : SEND
;	::->op : CALL
	.line	68; "../lcd1602.c"	LCD1602WriteCmd(LCD_MODE_STD);              /*LCD׼ģʽ8λݴͣ2ʾַ5*7*/
	MOV	R0,# 0x38
	PAGESEL	_LCD1602WriteCmd
	CALL	_LCD1602WriteCmd
	PAGESEL	$
;	::->op : SEND
;	::->op : CALL
	.line	69; "../lcd1602.c"	LCD1602WriteCmd(DISP_OFF);                  /*ʾر*/
	MOV	R0,# 0x0b
	PAGESEL	_LCD1602WriteCmd
	CALL	_LCD1602WriteCmd
	PAGESEL	$
;	::->op : SEND
;	::->op : CALL
	.line	70; "../lcd1602.c"	LCD1602WriteCmd(DISP_CLR);                  /**/ 
	MOV	R0,# 0x01
	PAGESEL	_LCD1602WriteCmd
	CALL	_LCD1602WriteCmd
	PAGESEL	$
;	::->op : SEND
;	::->op : CALL
	.line	73; "../lcd1602.c"	LCD1602WriteCmd(CUR_AUTO_R);                /*ùֲԶ*/
	MOV	R0,# 0x06
	PAGESEL	_LCD1602WriteCmd
	CALL	_LCD1602WriteCmd
	PAGESEL	$
;	::->op : SEND
;	::->op : CALL
	.line	74; "../lcd1602.c"	LCD1602WriteCmd(DISP_ON&CUR_OFF&BLINK_OFF); /*ʾ޹, 겻˸*/
	MOV	R0,# 0x0c
	PAGESEL	_LCD1602WriteCmd
	CALL	_LCD1602WriteCmd
	PAGESEL	$
;	::->op : LABEL
;	::->op : ENDFUNCTION
	CRET	
	.def _LCD1602_Init_function_end, debug, value=$

; exit point of _LCD1602_Init



func._LCD1602Write	.code
;***
;  PostBlock Stats: dbName = C
;***
;entry:  _LCD1602Write	;Function start
; 2 exit points
;has an exit
;functions called:
;   _delay_ms
;   _Write_cd4094
;   _delay_us
;   _delay_ms
;   _Write_cd4094
;   _delay_us
;2 compiler assigned registers:
;   r0x1018
;   STK00
;; Starting PostCode block
	.def _LCD1602Write_function_begin, debug, value=$

;	::->op : LABEL
;	::->op : FUNCTION
_LCD1602Write	;Function start
; 2 exit points
;	::->op : RECEIVE
	.line	50; "../lcd1602.c"	void LCD1602Write(unsigned char data_out)
	BANKSEL	r0x1018
	MOV	r0x1018, R0
;	::->op :*  =
	.line	52; "../lcd1602.c"	LCD1602_CLR_E();
	BANKSEL	_P1LR_bits
	CLR	_P1LR_bits, 5
;	::->op : SEND
;	::->op : CALL
	.line	56; "../lcd1602.c"	delay_ms(1);
	MOV	R0,# 0x01
	BANKSEL	STK00
	MOV	STK00, R0
	MOV	R0,# 0x00
	PAGESEL	_delay_ms
	CALL	_delay_ms
	PAGESEL	$
;	::->op :*  =
	.line	58; "../lcd1602.c"	LCD1602_SET_RS();
	BANKSEL	_P3LR_bits
	SET	_P3LR_bits, 4
;	::->op :*  =
	.line	59; "../lcd1602.c"	LCD1602_CLR_RW();
	BANKSEL	_P3LR_bits
	CLR	_P3LR_bits, 5
;	::->op : SEND
;	::->op : CALL
	.line	60; "../lcd1602.c"	LCD1602_wBus(data_out);
	BANKSEL	r0x1018
	MOVZ	R0, r0x1018
	PAGESEL	_Write_cd4094
	CALL	_Write_cd4094
	PAGESEL	$
;	::->op :*  =
	.line	61; "../lcd1602.c"	LCD1602_SET_E();
	BANKSEL	_P1LR_bits
	SET	_P1LR_bits, 5
;	::->op : SEND
;	::->op : CALL
	.line	62; "../lcd1602.c"	delay_us(1);
	MOV	R0,# 0x01
	BANKSEL	STK00
	MOV	STK00, R0
	MOV	R0,# 0x00
	PAGESEL	_delay_us
	CALL	_delay_us
	PAGESEL	$
;	::->op :*  =
	.line	63; "../lcd1602.c"	LCD1602_CLR_E();
	BANKSEL	_P1LR_bits
	CLR	_P1LR_bits, 5
;	::->op : LABEL
;	::->op : ENDFUNCTION
	CRET	
	.def _LCD1602Write_function_end, debug, value=$

; exit point of _LCD1602Write



func._LCD1602WriteCmd	.code
;***
;  PostBlock Stats: dbName = C
;***
;entry:  _LCD1602WriteCmd	;Function start
; 2 exit points
;has an exit
;functions called:
;   _delay_ms
;   _Write_cd4094
;   _delay_us
;   _delay_ms
;   _Write_cd4094
;   _delay_us
;2 compiler assigned registers:
;   r0x103E
;   STK00
;; Starting PostCode block
	.def _LCD1602WriteCmd_function_begin, debug, value=$

;	::->op : LABEL
;	::->op : FUNCTION
_LCD1602WriteCmd	;Function start
; 2 exit points
;	::->op : RECEIVE
	.line	32; "../lcd1602.c"	void LCD1602WriteCmd(unsigned char cmd)
	BANKSEL	r0x103E
	MOV	r0x103E, R0
;	::->op :*  =
	.line	34; "../lcd1602.c"	LCD1602_CLR_E();
	BANKSEL	_P1LR_bits
	CLR	_P1LR_bits, 5
;	::->op : SEND
;	::->op : CALL
	.line	38; "../lcd1602.c"	delay_ms(1);
	MOV	R0,# 0x01
	BANKSEL	STK00
	MOV	STK00, R0
	MOV	R0,# 0x00
	PAGESEL	_delay_ms
	CALL	_delay_ms
	PAGESEL	$
;	::->op :*  =
	.line	40; "../lcd1602.c"	LCD1602_CLR_RS();
	BANKSEL	_P3LR_bits
	CLR	_P3LR_bits, 4
;	::->op :*  =
	.line	41; "../lcd1602.c"	LCD1602_CLR_RW();
	BANKSEL	_P3LR_bits
	CLR	_P3LR_bits, 5
;	::->op : SEND
;	::->op : CALL
	.line	42; "../lcd1602.c"	LCD1602_wBus(cmd);
	BANKSEL	r0x103E
	MOVZ	R0, r0x103E
	PAGESEL	_Write_cd4094
	CALL	_Write_cd4094
	PAGESEL	$
;	::->op :*  =
	.line	43; "../lcd1602.c"	LCD1602_SET_E();
	BANKSEL	_P1LR_bits
	SET	_P1LR_bits, 5
;	::->op : SEND
;	::->op : CALL
	.line	44; "../lcd1602.c"	delay_us(1);
	MOV	R0,# 0x01
	BANKSEL	STK00
	MOV	STK00, R0
	MOV	R0,# 0x00
	PAGESEL	_delay_us
	CALL	_delay_us
	PAGESEL	$
;	::->op :*  =
	.line	45; "../lcd1602.c"	LCD1602_CLR_E();
	BANKSEL	_P1LR_bits
	CLR	_P1LR_bits, 5
;	::->op : LABEL
;	::->op : ENDFUNCTION
	CRET	
	.def _LCD1602WriteCmd_function_end, debug, value=$

; exit point of _LCD1602WriteCmd


;	code size estimation:
;	  584+  301 =   885 instructions ( 2372 byte)

	.type _LCD1602WriteCmd,  32
	.dim _LCD1602WriteCmd, 1, (_LCD1602WriteCmd_function_end&0xFF00)>>8, _LCD1602WriteCmd_function_end&0xFF,0,32,0,46 , 1, 1
	.type _LCD1602Write,  32
	.dim _LCD1602Write, 1, (_LCD1602Write_function_end&0xFF00)>>8, _LCD1602Write_function_end&0xFF,0,50,0,64 , 1, 1
	.type _LCD1602_Init,  32
	.dim _LCD1602_Init, 1, (_LCD1602_Init_function_end&0xFF00)>>8, _LCD1602_Init_function_end&0xFF,0,66,0,75 , 1, 1
	.type _LCD1602_setxy,  32
	.dim _LCD1602_setxy, 1, (_LCD1602_setxy_function_end&0xFF00)>>8, _LCD1602_setxy_function_end&0xFF,0,78,0,88 , 1, 1
	.type _LCD1602_Clear,  32
	.dim _LCD1602_Clear, 1, (_LCD1602_Clear_function_end&0xFF00)>>8, _LCD1602_Clear_function_end&0xFF,0,91,0,95 , 1, 1
	.type _LCD1602_PrintString,  32
	.dim _LCD1602_PrintString, 1, (_LCD1602_PrintString_function_end&0xFF00)>>8, _LCD1602_PrintString_function_end&0xFF,0,98,0,105 , 1, 1
	.type _LCD1602_PrintInteger,  32
	.dim _LCD1602_PrintInteger, 1, (_LCD1602_PrintInteger_function_end&0xFF00)>>8, _LCD1602_PrintInteger_function_end&0xFF,0,107,0,128 , 1, 1
	.type _LCD1602_PrintHEX_TWO,  32
	.dim _LCD1602_PrintHEX_TWO, 1, (_LCD1602_PrintHEX_TWO_function_end&0xFF00)>>8, _LCD1602_PrintHEX_TWO_function_end&0xFF,0,130,0,149 , 1, 1
	.type _LCD1602_PrintHEX,  32
	.dim _LCD1602_PrintHEX, 1, (_LCD1602_PrintHEX_function_end&0xFF00)>>8, _LCD1602_PrintHEX_function_end&0xFF,0,150,0,208 , 1, 1
	.def __00010000, debug, type = 8, class = 10, value = 1
	.def _0, debug, value = 1, type = 26, class = 8
	.def _1, debug, value = 1, type = 26, class = 8
	.def _2, debug, value = 1, type = 26, class = 8
	.def _3, debug, value = 1, type = 26, class = 8
	.def _4, debug, value = 1, type = 26, class = 8
	.def _5, debug, value = 1, type = 26, class = 8
	.def _6, debug, value = 1, type = 26, class = 8
	.def _7, debug, value = 1, type = 26, class = 8

	.end
